package model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Observable;

public class Catalogo extends Observable {

	private ProxyPezzo pezzo;
	String tmp;
	private String filter = "Tutti";
	private String[] log;
	private LinkedList<ProxyPezzo> pezzi = new LinkedList<ProxyPezzo>();

	public void addPezzo(ProxyPezzo pezzo) {
		this.pezzo = pezzo;

		pezzi.add(pezzo);

		sort();
	}

	public LinkedList<ProxyPezzo> getPezzi() {
		return pezzi;
	}

	public void sort() {
		Collections.sort(pezzi);

		up();

	}

	public String genText() {

		log = new String[pezzi.size()];

		if (filter.equalsIgnoreCase("Tutti")) {

			for (int i = 0; i < pezzi.size(); i++) {
				log[i] = (pezzi.get(i).getCodeID() + " "
						+ pezzi.get(i).getDate() + " " + pezzi.get(i).getSala()
						+ " " + pezzi.get(i).getDescription() + "\n")
						.toString();
			}

			tmp = new String();
		} else {
			for (int j = 0; j < pezzi.size(); j++) {
				if (filter.equalsIgnoreCase(pezzi.get(j).getSala())) {
					log[j] = (pezzi.get(j).getCodeID() + " "
							+ pezzi.get(j).getDate() + " "
							+ pezzi.get(j).getSala() + " "
							+ pezzi.get(j).getDescription() + "\n").toString();
				}
			}
			tmp = new String();
		}

		for (int j = 0; j < log.length; j++) {
			if (log[j] == null) {
				log[j] = " ";

			}
			tmp = (tmp + log[j]);
		}

		return tmp;

	}

	public String getFilter() {
		return filter;
	}

	public void setFilter(String filter) {
		this.filter = filter;
		up();
	}

	public void up() {

		setChanged();
		notifyObservers();
	}
}
